unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, AppEvnts;

type
  TMainForm = class(TForm)
    ApplicationEvents1: TApplicationEvents;
    Memo1: TMemo;
    Panel1: TPanel;
    imgKONIEC: TImage;
    StaticText1: TStaticText;
    procedure ApplicationEvents1Activate(Sender: TObject);
    procedure ApplicationEvents1Message(var Msg: tagMSG; var Handled: Boolean);
    procedure FormCreate(Sender: TObject);
    procedure ApplicationEvents1Idle(Sender: TObject; var Done: Boolean);
    procedure imgKONIECClick(Sender: TObject);
  private

  public
    procedure Koniec();
  end;

var
  MainForm: TMainForm;

implementation
{$R *.dfm}
{------------------------------------------------------------------------------}
procedure TMainForm.ApplicationEvents1Message(var Msg: tagMSG; var Handled: Boolean);
begin
   {
   Memo1.Lines.Add(IntToStr(Msg.message));
   Handled := true;
   }
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
   Memo1.Clear();
end;

procedure TMainForm.imgKONIECClick(Sender: TObject);
begin
	Koniec();
end;

procedure TMainForm.Koniec();
begin
	if Application.MessageBox('Koniec pracy', 'Uwaga', MB_YESNO or MB_ICONEXCLAMATION) = IDYES then
	begin
      Application.Terminate();
	end;
end;

procedure TMainForm.ApplicationEvents1Activate(Sender: TObject);
begin
	ShowMessage('Application Activate');
end;

procedure TMainForm.ApplicationEvents1Idle(Sender: TObject; var Done: Boolean);
var
	czas : TTime;
   
begin
	czas := Time();
   Memo1.Lines.Add(TimeToStr(czas));
   StaticText1.Caption := TimeToStr(czas);
end;

end.
